/************************************************************************/
/*                                                                      */
/* Borland Enterprise Core Objects                                      */
/*                                                                      */
/* Copyright (c) 2003-2005 Borland Software Corporation                 */
/*                                                                      */
/************************************************************************/

using System;
using System.Windows.Forms;
using System.Collections;
using System.ComponentModel;
using Borland.Eco.Handles;
using Borland.Eco.Services;
using Borland.Eco.ObjectRepresentation;
using Borland.Eco.UmlRt;

namespace Borland.Eco.WinForm
{
	public class EcoDataGridTextBoxColumn: DataGridTextBoxColumn
	{
		private void SetMaxLength()
		{
			ElementHandle handle = null;
			if (DataGridTableStyle != null)
				handle = DataGridTableStyle.DataGrid.DataSource as ElementHandle;

			if (handle != null)
				TextBox.MaxLength = MaxLengthSupportFunctions.GetMaxLength(PropertyDescriptor as RenderedTuplePropertyDescriptor, handle, TextBox.MaxLength);
		}

		public override PropertyDescriptor PropertyDescriptor
		{
			set
			{
			  base.PropertyDescriptor = value;
			  SetMaxLength();
			}
		}
	}
}
